/*********************************************/
/* Example Program for ET-ADuC847 STAMP V1.0 */
/* MCU      : ADuC847(XTAL = 32.768 KHz)     */
/*          : Frequency Bus = 12.582912 MHz  */
/* Compiler : Keil C51 (V7.50)               */
/* Function : Demo DAC Generate Sinewave 1KHz*/
/* Write By : ETT CO.,LTD.(May/2011)         */
/*********************************************/

/* include  section */
#include <aduc847.h>						// ADUC847 SFR : File
#include <stdio.h>                			// Prototype declarations for I/O functions

static bit Trig_Ready;						// 1/64mS Overflow Status

/*--------------------------------------------
The main C function.  Program execution Here 
---------------------------------------------*/
void main (void) 
{ 
  // Array[0..63] = 64 Step = Degree[0..360]/64 = 5.625/Step
  // Step Degree[0..63] = 0,5.625,11.25,16.875,...,354.375,360
  // Step Output[0..63] = (sin(x)*2048)+2048
  // Example = (sin(5.625)*2048)+2048
  //         = (0.098*2048)+2048
  //         = 2248.739 
  //         = 2048 
  //         = 0x08C8
  // Sine Function Table 
  static unsigned int code table_sine[64]=	// Sine Function Table
  {
     0x07FF, 0x08C8, 0x098E, 0x0A51, 	
	 0x0B0F, 0x0BC4, 0x0C71, 0x0D12,
 	 0x0DA7, 0x0E2E, 0x0EA5, 0x0F0D, 
	 0x0F63, 0x0FA6, 0x0FD7, 0x0FF5,
 	 0x0FFF, 0x0FF5, 0x0FD7, 0x0FA6, 
	 0x0F63, 0x0F0D, 0x0EA5, 0x0E2E,
 	 0x0DA7, 0x0D12, 0x0C71, 0x0BC4, 
	 0x0B0F, 0x0A51, 0x098E, 0x08C8,
 	 0x07FF, 0x0736, 0x0670, 0x05AD, 
	 0x04EF, 0x043A, 0x038D, 0x02EC,
 	 0x0257, 0x01D0, 0x0159, 0x00F1, 
	 0x009B, 0x0058, 0x0027, 0x0009,
 	 0x0000, 0x0009, 0x0027, 0x0058, 
	 0x009B, 0x00F1, 0x0159, 0x01D0,
 	 0x0257, 0x02EC, 0x038D, 0x043A, 
	 0x04EF, 0x05AD, 0x0670, 0x0736  
  };
  int   i = 0;
 
  PLLCON = 0x00;							// Initial Clock = 12.582912MHz

  /* Initial MCS51 Serial Port */
  /* Used Timer3 Gen. Baudrate */
  // Baud   = T3CON,T3FD
  // 9600   = 0x86,0x12
  // 19200  = 0x85,0x12
  // 38400  = 0x84,0x12
  // 57600  = 0x83,0x2D
  // 115200 = 0x82,0x2D
  // 230400 = 0x81,0x2D
  T3CON = 0x86;								// 9600BPS/12.58MHz(32.768KHz+PLL)
  T3FD  = 0x12;        
  SCON  = 0x50;  							// Serial Port Mode 1 (N,8,1)
  ES    = 0;     							// Disable Serial Interupt            
  TI    = 1;     							// Set TI to send First char of Keil-UART Function

  // Initial DAC
  DACCON &= ~0x10;							// DAC Output = Pin-14(DAC)
  DACCON &= ~0x08;							// DAC = 12 Bit Mode
  DACCON |=  0x04;							// DAC Scale = 0V..+AVDD
  DACCON |=  0x02;                  		// DAC = Normal Operate
  DACCON |=  0x01;                  		// Start Enable DAC Operate

  /* Print Message to RS232 */
  printf("\nET-STAMP ADuC847.....From ETT CO.,LTD");  
  printf("\nDemo DAC Generate Sinewave on DAC Pin");  
  
  // Start of Config Timer2  For Trigger = DAC 1KHz/64Cycle    
  // Fclk = 12.582912MHz
  // 1 Machine Cycle = 79.4728nS
  // 1 KHz = 1mS / 79.4728nS = 12582.912 Cycle
  // DAC Trig = 1mS/64
  //          = 196.608 Cycle = 197 Cycle
  // Timer2 Reload = 65536-197 = 65339 Cycle
  //               = 0xFF3B
  TH2 = 0xFF;								// Start Timer2 Value
  TL2 = 0x3B;  	
  RCAP2H = 0xFF;							// Reload Timer2 Value
  RCAP2L = 0x3B;
  ET2 = 1;									// Enable Timer2 Interrupt
  EA = 1;		  							//Enable Global Interrupt
  T2CON = 0x04;								// TR2 = 1(Start Timer2)+Config Timer2 = 16Bit Auto Reload
  //End of Config Timer2

  while(1)									// Loop Continue
  {
    while(!Trig_Ready);	 					// Wait 1/64mS Trigger

    DACH = (table_sine[i] >> 8) & 0xFF; 	// Update MSB DAC Sine Output(0V..+AVDD)
	DACL = (table_sine[i] & 0xFF);			// Update LSB DAC
	i++;									// Next Pointer
	i &= 0x3F;         						// 0..63

	Trig_Ready = 0;							// Reset Trigger Status
  }
}

//Timer2 Overflow Service Every 1/64mS
void timer2_service () interrupt 5
{
  Trig_Ready = 1;							// 1/64 Trigger Status
  TF2 = 0;									// Reset Timer2 Overflow
}


